/* 
 *  SideBar.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.CustomFieldListI;

import javafx.scene.control.TabPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;

public class SideBar {

    private final VBox sideBar;

    private final IntrinsicsTab intrinsicsTab;
    private final UUITab uuiTab;
    private final AttachedDataTab dataTab;
    private final AgentNotesTab agentNotesTab;
    private final CustomFieldsTab customFieldsTab;
    private final CustomerDataPane customerDataPane;
    //TODO conroy1 add in a future release
//    private final ContactSearchTab contactSearchTab;
//    private final CustomerSearchTab customerSearchTab;

    public SideBar(InteractionExecutor interactionExe, InteractionDataGUI gui) {
        sideBar = new VBox();
        sideBar.getStyleClass().add("sideBar");

        Text title = new Text("Customer Data");
        title.getStyleClass().add("title");
        sideBar.getChildren().add(title);

        customerDataPane = new CustomerDataPane(interactionExe, gui);
        sideBar.getChildren().add(customerDataPane.getPane());
        
        TabPane tabPane = new TabPane();

        intrinsicsTab = new IntrinsicsTab(interactionExe, gui);
        tabPane.getTabs().add(intrinsicsTab.getTab());

        uuiTab = new UUITab(interactionExe, gui);
        tabPane.getTabs().add(uuiTab.getTab());

        dataTab = new AttachedDataTab(interactionExe, gui);
        tabPane.getTabs().add(dataTab.getTab());

        agentNotesTab = new AgentNotesTab(interactionExe, gui);
        tabPane.getTabs().add(agentNotesTab.getTab());

        customFieldsTab = new CustomFieldsTab(interactionExe, gui);
        tabPane.getTabs().add(customFieldsTab.getTab());

        //TODO conroy1 add in a future release
//        contactSearchTab = new ContactSearchTab(interactionExe, gui); 
//        tabPane.getTabs().add(contactSearchTab.getTab());
//        
//        customerSearchTab = new CustomerSearchTab(interactionExe, gui);
//        tabPane.getTabs().add(customerSearchTab.getTab());

        sideBar.getChildren().add(tabPane);
    }

    public VBox getSideBar() {
        return sideBar;
    }
    
//    public ContactSearchTab getContactSearchTab() {
//		return contactSearchTab;
//	}
//
//	public CustomerSearchTab getCustomerSearchTab() {
//		return customerSearchTab;
//	}
	
    public void update(InteractionDataI data) {
        intrinsicsTab.update(data);
        uuiTab.update(data);
        dataTab.update(data);
        agentNotesTab.update(data);
        customerDataPane.update(data);
    }

    public void updateCustomFields(CustomFieldListI customFields) {
        customFieldsTab.update(customFields);
    }
}
